#include <iostream>
#include <queue>
#include <vector>

using namespace std;

int main(){
  ios_base::sync_with_stdio(false), cin.tie(0);
  
  int n; cin>>n;
  vector<int> x(n), y(n), min(n, -1);

  for (int i = 0; i < n; ++i){
    cin>>x[i];
  }

  for (int i = 0; i < n; ++i){
    cin>>y[i];
  }

  priority_queue<pair<int, int>, vector<pair<int, int>>, greater<pair<int, int>>> queue;

  for (int i = 0; i < n; ++i){
    int pointO = (x[i] + y[i - 1] - x[i - 1] - y[i]) / 2;
    int pointH = y[i - 1] - pointO;

    while (!queue.empty()){
      auto p = queue.top();

      if (p.first > y[i - 1])
        break;
      
      queue.pop();

      int xP = x[p.second];
      int yP = y[p.second];

      int xI = y[i] - yP <= x[i] - (x[i - 1] + pointO) ? x[i] - (y[i] - yP) : x[i];

      if (min[p.second] == -1 || xI - xP < min[p.second])
        min[p.second] = xI - xP;
    }

    queue.push({y[i], i});
  }

  while (!queue.empty()) queue.pop();

  for (int i = n - 1; i >= 0; --i){
    int pointO = (x[i + 1] + y[i] - x[i] - y[i + 1]) / 2;
    int pointH = y[i] - pointO;

    while (!queue.empty()){
      auto p = queue.top();

      if (p.first > y[i])
        break;
      
      queue.pop();

      int xP = x[p.second];
      int yP = y[p.second];

      int xI = y[i] - yP <= pointO ? x[i] + (y[i] - yP) : x[i];

      if (min[p.second] == -1 || xP - xI < min[p.second])
        min[p.second] = xP - xI;
    }

    queue.push({y[i], i});
  }
  
  for (int i = 0; i < n; ++i){
    cout<<min[i]<<'\n';
  }

  return 0;
}